<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('galery_files', function (Blueprint $table) {
            $table->string('id', 21)->primary();
            $table->string('galeri_id', 21);
            $table->string('file_name');
            $table->string('url');
            $table->boolean('is_thumbnail')->default(false);
            $table->timestamps();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('galery_files');
    }
};
